import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import java.util.Vector;

public class UDDIFindBusiness5 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector fqv = new Vector();
		fqv.add(new FindQualifier(FindQualifier.sortByNameDesc));
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		Vector names = new Vector();
		names.add(new Name("IBM"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, fqs, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(bis.size()+" business(es) found\n");
		Vector biv = bis.getBusinessInfoVector();
		for (int i = 0; i < biv.size(); i++) {
			BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
			System.out.println(bi.getNameString());
			System.out.println(bi.getBusinessKey());
			System.out.println("\n");
		}
	}
}